<?php

namespace App\Http\Controllers;
use App\User; 

use Illuminate\Http\Request;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        if(session( 'test_db') == 'yes' ){
            \DB::setDefaultConnection('mysql2');
        }
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        
      // $img = file_get_contents(asset('img/c.jpeg'));
      // $imgdata = base64_encode($img);
      // dd($imgdata);
      if(session('mobile-pointage') and session('mobile-pointage')=="OK")
        return $this->mobile_home();
      
			if(session('type_user') and  session('type_user')=='compta')
			  return redirect()->route('compta.index');
      
      $sysUserRoles = \Auth::user()->sysUserRoles;
      $userInterface = true;
      $ecoles = $sysUserRoles->groupBy('ecole_id');
      //dd($ecoles->first());
      if($ecoles->count()==1){
        $ecole_id = $ecoles->first()->first()->ecole_id;
        session(['ecole_id'=>$ecole_id]);
        return redirect()->route('home.ecole',['ecole_id'=>$ecole_id]);
      }
      else {
          $ecole_id = \Auth::user()->ecole_id;
          session(['ecole_id'=>$ecole_id]);
      }
      return view('home', compact('ecoles') );

		  //return view("admin_ecole.accueil", compact('sysUserRoles'));
		

    }

    public function changer_annee(Request $re){
        \App\Config::$annee = null;
        session(['annee_id'=>$re->annee_id]);
        return redirect()->back();
    }
    public function home_ecole($ecole_id){
      //$user = User::with('sysUserRoles.ecole')->find(\Auth::user()->id);
      if($sysUserRoles = \Auth::user()->sysUserRoles->where('ecole_id',$ecole_id)){
        if($sysUserRoles->count()==0){
            \Auth::logout();
            return redirect('/login');
        }
        session(['ecole_id'=>$ecole_id]);
        //dd($sysUserRoles);
        $userInterface = true;
        return view('home', compact('sysUserRoles','userInterface') );
      }
      else return view('erreur_404');
    }
	
    public function mobile_home()
    {
		$sysUserRoles = \Auth::user()->sysUserRoles;
		$userInterface = true;
		return view('home_mobilee', compact('sysUserRoles','userInterface') );
    }
}