<?php

namespace App\Exports;

use App\Masomwetu\Comptabilite\MouvementCompte;
use App\Masomwetu\Payment\MpFraisPaiement;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\Exportable;

use Maatwebsite\Excel\Concerns\ShouldAutoSize;

use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\WithDrawings;
use PhpOffice\PhpSpreadsheet\Worksheet\Drawing;
 
// class EleveExport implements FromQuery
class RapportFinExport implements  FromView /*WithDrawings, , WithEvents, ShouldAutoSize */
{
    use Exportable;
    public function drawings(){
        $draw = new Drawing();
        $draw->setName('Logo_Ecole');
        $draw->setDescription('Cherad logo');
        $draw->setPath(public_path('//img/email/ecole-logo.jpg'));
        $draw->setHeight(50);
        $draw->setCoordinates('A20');

        $draw1 = new Drawing();
        $draw1->setName('Logo_Msw');
        $draw1->setDescription('Masomwetu logo');
        $draw1->setPath(public_path('//img/email/pt-logo.jpeg'));
        $draw1->setHeight(50);
        $draw1->setCoordinates('G20');

        return [$draw,$draw1];
    }
    public function forDate( $date_rapport)
    {
        $this->date_rapport = $date_rapport;
        
        return $this;
    } 
	
    public function forDatas( $datas)
    {
        $this->datas = $datas;
        
        return $this;
    } // [];//
	public function view(): View
	{
        $mpfraispaiements = MpFraisPaiement::with('msEleve.enfant','mpFraisClasse.mpFrais','mpFraisClasse.msClasse.msPromotion.section')
            ->where('payer_le',$this->date_rapport)->get();
        $mouvementComptes = MouvementCompte::with('compte.categorieCompte')->where('date_mouv',$this->date_rapport)->get();
            
        // 
        $datas = array_merge( $this->datas, compact('mpfraispaiements','mouvementComptes','date_rapport')) ;
        $date_rapport = $this->date_rapport;
		return view('exports.rapport_financier',$datas);
	}
    
    /*
    public function query()
    {
        return MsEleve::query()->where('ms_classe_id', $this->classe_id);
    }
	
	public function registerEvents(): array
    {
        return [
            AfterSheet::class    => function(AfterSheet $event) {
                $cellRange = 'A1'; // All headers
                $event->sheet->getDelegate()->getStyle($cellRange)->getFont()->setSize(6);
            },
        ];
    }
	 $styleArray = [
		'borders' => [
			'outline' => [
				'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
				'color' => ['argb' => 'FFFF0000'],
			],
		],
	];

	$worksheet->getStyle('B2:G8')->applyFromArray($styleArray); */
}
