<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithMultipleSheets;
class GrilleSynthFeuilExport implements WithMultipleSheets
{
	use Exportable;
	protected $year;
	public function __construct($classe_id,$travaux)
	{
		$this->classe_id = $classe_id;
		$this->travaux = $travaux;
	}
	/**
	* @return array
	*/
	public function sheets(): array
	{
		$TravauxLBL = ",1ère Période,2ème Période,1er Examen,3ème Période,4ème Période,2ème Examen,5ème Période,6ème Période,3ème Examen";
		$TravauxLBL = explode(',',$TravauxLBL);
		$sheets = [];
		foreach ($this->travaux as $trav) {
			$nomPeriode = $TravauxLBL[$trav];
			$sheets[] = (new GrilleSynthExport())
			->forName($nomPeriode)
			->forTravail($trav)
			->forClasse($this->classe_id)
			->withCote(true)
			->forNomPeriode($nomPeriode);
		}
		return $sheets;
	}
}

