<?php

namespace App\Exports;


use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\WithTitle;
use Illuminate\Contracts\View\View;


class ErrorExport implements FromView , WithTitle
{
    use Exportable;
	private $tabError = [];
	private $name = '';
    public function forName($nom)
    {
        $this->name = $nom;
        
        return $this;
    } 
    public function forTabError( $tab)
    {
        $this->tabError = $tab;
        
        return $this;
    } 
	
	public function view(): View
	{
		// return view('exports.error_import',['name'=>$this->name,'tabError'=>$this->tabError]);
		return view('exports.error_import',['name'=>$this->name,'tabError'=>$this->tabError]);
	}
	public function title(): string
	{
		$n = str_replace( 'Grille-Synth-','',$this->name);
		$n = str_replace( '.xlsx','',$n);
		if(strlen($n)>30)
			$n = substr($n,0,27);
		return $n;
	}
}
// Grille-Synth-7e EB-A_1ère Période(1)