<?php

namespace App\Exports;

use App\Masomwetu\Scholar\MsEleve;
use App\Masomwetu\Scholar\Enfant;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\Exportable;

use Maatwebsite\Excel\Concerns\ShouldAutoSize;

use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;
 
use \App\Masomwetu\Payment\MpFrais;
use \App\Masomwetu\Payment\MpFraisClasse;
// class EleveExport implements FromQuery
class EleveExport implements FromView, WithEvents/* , ShouldAutoSize */
{
    use Exportable;
    private $type = '';
    public function forClasse(int $id)
    {
        $this->classe_id = $id;
        
        return $this;
    }
    public function forType( $type)
    {
        $this->type = $type;
        
        return $this;
    } 
	// [];//
	public function view(): View
	{
        if( $this->classe_id){
            $eleves = MsEleve::with('enfant')->where('ms_classe_id', $this->classe_id)->get();
            if($this->type=="frais"){
                $mpFraisClassses = MpFraisClasse::with('mpFrais')->where('ms_classe_id',$this->classe_id)->get();
                //dd($mpFraisClassses);
                return view('exports.eleves_frais', [ 'mseleves' => $eleves,'mpFraisClassses'=>$mpFraisClassses ]);
            }
        }
        else if( $this->classe_id==0){
            $ms_annee_scolaire_id = \App\Config::getIdAnnee();
            $ecole_id =  \App\Config::getEcoleId();
            $eleves = MsEleve::with('enfant','msClasse','msPromotion')
            ->where('ms_annee_scolaire_id', $ms_annee_scolaire_id)
            ->where('ecole_id', $ecole_id)
            ->get();
            if($this->type=="frais"){
                // $mpFraisClassses = MpFraisClasse::with('mpFrais','msClasse')
                // ->where('ms_annee_scolaire_id', $ms_annee_scolaire_id)
                // ->whereHas('msClasse',function($q)use($ecole_id){return $q->where('ecole_id', $ecole_id);})
                // ->get()->groupBy('mp_frais_id');
                $mpFrais = MpFrais::with('mpFraisClasses.msClasse')
                ->whereHas('mpFraisClasses.msClasse',function($q)use($ecole_id){return $q->where('ecole_id', $ecole_id);})
                ->whereHas('mpFraisClasses',function($q)use($ms_annee_scolaire_id){return $q->where('ms_annee_scolaire_id', $ms_annee_scolaire_id);})
                ->get()->sortBy(function ($product, $key) {
                    return $product->mp_type_frais_id.' '.$product->priorite;
                });
                // $echo ='';
                //foreach($mpFrais as $e)$echo.= $e->frais."[$e->mp_type_frais_id.' '.$e->priorite] ";
                // dd($echo,$mpFrais);
                return view('exports.eleves_frais', [ 'mseleves' => $eleves,'mpFrais'=>$mpFrais,'tous'=>true ]);
            }
        }
		return view('exports.eleves', [ 'mseleves' => $eleves ]);
	}
	
    public function query()
    {
        return MsEleve::query()->where('ms_classe_id', $this->classe_id);
    }
	
	public function registerEvents(): array
    {
        return [
            AfterSheet::class    => function(AfterSheet $event) {
                $cellRange = 'A1'; // All headers
                $event->sheet->getDelegate()->getStyle($cellRange)->getFont()->setSize(6);
            },
        ];
    }
	/* $styleArray = [
		'borders' => [
			'outline' => [
				'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
				'color' => ['argb' => 'FFFF0000'],
			],
		],
	];

	$worksheet->getStyle('B2:G8')->applyFromArray($styleArray); */
}
