<?php

namespace App\Exceptions;

use Exception;
use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;

class Handler extends ExceptionHandler
{
    /**
     * A list of the exception types that are not reported.
     *
     * @var array
     */
    protected $dontReport = [
        //
    ];

    /**
     * A list of the inputs that are never flashed for validation exceptions.
     *
     * @var array
     */
    protected $dontFlash = [
        'password',
        'password_confirmation',
    ];

    /**
     * Report or log an exception.
     *
     * @param  \Exception  $exception
     * @return void
     */
    
    public function report(Exception $exception)
    {
        // Log l'exception Laravel normalement
        parent::report($exception);
    
        // 👇 Forcer les erreurs PHP bas-niveau à être loguées aussi
        set_error_handler(function ($severity, $message, $file, $line) {
            \Log::error("PHP Error: {$message} in {$file} on line {$line}");
            return false; // Laisser PHP continuer à gérer l'erreur
        });
    
        set_exception_handler(function ($exception) {
            \Log::error('Uncaught Exception: ' . $exception->getMessage(), [
                'file' => $exception->getFile(),
                'line' => $exception->getLine(),
                'trace' => $exception->getTraceAsString(),
            ]);
        });
    
        error_reporting(E_ALL); // 👈 Capturer tous les niveaux PHP
    }


    /**
     * Render an exception into an HTTP response.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Exception  $exception
     * @return \Illuminate\Http\Response
     */
    public function render($request, Exception $exception)
    {
        return parent::render($request, $exception);
    }
}