		
@extends('template')
@section('style')
	<style>
.info-box {
    display: block;
    min-height: 90px;
    background: #ecf0f5;
    width: 100%;
    box-shadow: 2px 2px 2px rgba(0,0,0,0.5);
    border-radius: 2px;
    margin-bottom: 15px;
}
.table-striped > tbody > tr:nth-of-type(2n+1) {
    background-color: #ffeaea;
}
.table-striped > tbody > tr:nth-of-type(2n+0) {
    background-color: #d8f0f7;
}
	</style>
	
@endsection
@section('content')

		<div class="col-sm-12 col-sm-offset-0">
				
		<div class="box box-info">
			<div class="box-header with-border">
				<h2 class="box-title">Rapport Général de suivi des dépenses</h2>
				
				<div class="box-tools pull-right">
					<button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
				</div>
			</div>
			<div class="box-body">
				<div class="row">
					<div class="col-md-6 col-sm-6 col-xs-12">
						<div class="info-box">
							<span class="info-box-icon bg-aqua"><i class="glyphicon glyphicon-usd"></i></span>

							<div class="info-box-content">
								<h3 class="info-box-text"><b>Demandes effectuée</b></h3>
								<span class="info-box-number">
									{{ chiffre($total_demande_usd) }}<small> $</small>
									{{ chiffre($total_demande_cdf) }}<small> CDF</small>
								</span>
							</div>
							<!-- /.info-box-content -->
						</div>
						<!-- /.info-box -->
					</div>
					<!-- /.col -->
					<!-- /.col -->

					<div class="col-md-6 col-sm-6 col-xs-12">
						<div class="info-box">
							<span class="info-box-icon bg-green"><i class="glyphicon glyphicon-thumbs-up"></i></span>

							<div class="info-box-content">
								<h3 class="info-box-text"><b>Montant Suivi</b></h3>
								<span class="info-box-number">
								{{chiffre($total_justif_usd)}}<small> $</small>
								{{chiffre($total_justif_cdf)}}<small> CDF</small>
								</span>
							</div>
							<!-- /.info-box-content -->
						</div>
						<!-- /.info-box -->
					</div>
					<!-- /.col -->
				</div>
				<br/>
				<div class="row">
					<div class="col-md-offset-3 col-md-6 col-sm-6 col-xs-12">
						<div class="info-box">
							<span class="info-box-icon bg-red"><i class="glyphicon glyphicon-folder-open"></i></span>

							<div class="info-box-content">
								<h3 class="info-box-text">Montant à suivre</h3>
								<span class="info-box-number">
								{{chiffre($a_suivre_usd)}}<small> $</small>
								{{chiffre($a_suivre_cdf)}}<small> CDF</small>
								</span>
							</div>
							<!-- /.info-box-content -->
						</div>
						<!-- /.info-box -->
					</div>
				</div>
				
			</div>
		</div>
		
		<div class="box box-info">
			<div class="box-header with-border">
				<h2 class="box-title">Listes des fiche de sortie à suivre</h2>
				
				<div class="box-tools pull-right">
					<button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
				</div>
			</div>
			<div class="box-body">
				<table id="datatable-cashfichesorties" class="table table-stripedd table-bordered">
					<thead>
					</thead>
					<tbody>
					@php 					
						$STR = "1 JANVIER FERVRIER MARS AVRIL MAIS JUIN JUILLET AOUT SEPTEMBRE OCTOBRE NOVEMBRE DECEMBRE";
						$MOIS = explode(' ',$STR);
					@endphp
					@foreach($MoisMouvementcompte as $mois => $mouvements)
						@php 
							$total_usd=0;
							$total_cdf=0;
							$total_a_s_usd=0;
							$total_a_s_cdf=0;
						@endphp
						<tr style="    background: #f4f4f4;">
							<th colspan=6>Sorties du mois de: {{ $MOIS[(int)$mois]??$mois }}</th>
						</tr>
						<tr  style="    background: #f4f4f4;">
							
							<th>Catégorie</th>
							<th>Motif</th>
							<th >Montant USD</th>
							<th >Montant CDF</th>
							<th >A suivre USD</th>
							<th >A suivre CDF</th>
							<th>Date</th>
							<th></th>
						</tr>
						@foreach($mouvements as  $mouvement)
							<tr>
								@php 
									$total_usd+=$mouvement->montant_usd;
									$mnt_s_usd = $mouvement->montant_usd - $mouvement->cashSuivis->sum('montant_usd');
									
									$total_cdf+=$mouvement->montant_cdf;
									$mnt_s_cdf = $mouvement->montant_cdf - $mouvement->cashSuivis->sum('montant_cdf');
								@endphp
								<td>{{ $mouvement->compte->categorieCompte->categorie }}</td>
								<td>{{ $mouvement->libelle }}</td>
								<td>{{ chiffre($mouvement->montant_usd) }} </td>
								<td>{{ chiffre($mouvement->montant_cdf) }} </td>
								
								@if($mouvement->faire_suivi)
									<td>{{ chiffre($mnt_s_usd )}}</td> <td>{{ chiffre($mnt_s_cdf )}}</td> 
									@php
										$total_a_s_cdf+=$mnt_s_cdf;
										$total_a_s_usd+=$mnt_s_usd;
									@endphp
								@endif
								
								<td>{{ $mouvement->date_fiche }}</td>

								<td>
										<a class="btn btn-small btn-info btn-xs"
										href="{{ route('cash.fiche.detail',['id'=>$mouvement->id]) }}">Détail</a>
								</td>
							</tr>
						@endforeach
						<tr style="
    border-bottom: solid;
">
							<th colspan=2>Total du mois</th>
							<th>{{ chiffre($total_usd) }} </th><th> {{ chiffre($total_cdf) }}</th>
							<th>{{ chiffre($total_a_s_usd) }}</th><th> {{chiffre($total_a_s_cdf) }}</th>
							<th colspan=2></th>
						</tr>
					@endforeach
					</tbody>
				</table>
		
		
		
			</div>
			<div class="box-footer">
				
			</div>
			<!-- /.box-footer -->
		</div>
  </div>
			
@endsection

@section('script')
	
	<script> 
	
	
	</script> 
@endsection		