
@php
	if(!isset($personnaliser_mois))
		$personnaliser_mois = false;
		$paiements=[
		["du"=>"2022-09-05","au"=>"2022-09-27"],
		["du"=>"2022-09-28","au"=>"2022-10-24"],
		["du"=>"2022-10-25","au"=>"2022-11-24"],
		["du"=>"2022-11-25","au"=>"2022-12-23"],
		["du"=>"2022-12-24","au"=>"2023-01-23"]];
		$periode_mois = [];
		foreach($paiements as $p){
			$c = date("y/m/d",strtotime($p["au"])).':'.date("d/m",strtotime($p["du"]));
			$periode_mois[$c] = $p;
		}
	
@endphp
@php 
	$entree = '<span class="text-green fa fa-arrow-right"></span> ';
	$sortie = '<span class="text-red fa fa-arrow-left"></span> ';
	$tot_s = 0;
	$tot_e_cdf = $tot_e_usd = $tot_s_cdf = $tot_s_usd = 0;
	
	$mouvements_entrees = $mouvements->filter(function ($value, $key) use($compte){
		//if(!$value->parents_ids["final"])dd($value->parents_ids["final"]);
		return ($compte->id==$value->compte_final or in_array($compte->id, $value->parents_ids["final"]));
	});
	
	$mouvements_sorties = $mouvements->filter(function ($value, $key) use($compte) {
		// return $compte->id==$value->compte_initial;
		if(!is_array($value->parents_ids["initial"]))dd($value);
		return ($compte->id==$value->compte_initial or (is_array($value->parents_ids["initial"]) and in_array($compte->id, $value->parents_ids["initial"])));
	});
	
	/*dd($mouvements->filter(function ($value, $key) {
		return $value->compteFinal  ?($value->compteFinal->categorieCompte->id==1):false;
	}));*/
	$mnt_tot_en_usd = $mouvements_entrees->sum('montant_usd');
	$mnt_tot_en_cdf = $mouvements_entrees->sum('montant_cdf');
	
	$mnt_tot_so_usd = $mouvements_sorties->sum('montant_usd');
	$mnt_tot_so_cdf = $mouvements_sorties->sum('montant_cdf');
	$solde_cdf = $mnt_tot_en_cdf - $mnt_tot_so_cdf;
	$solde_usd = $mnt_tot_en_usd - $mnt_tot_so_usd;

	$taux = \App\Masomwetu\Comptabilite\TauxChange::first();
	$taux = $taux?$taux->usd_cdf:2000;
	$solde_positif = (($taux * $solde_usd)+$solde_cdf) <=0;
@endphp
<style>
.tr-detail-mois {
  font-size: 12px;
  font-style: italic;
  background: #f7f7f7;
  border: solid 3px black;
}
.tr-detail-mois:hover {
  background: #00ffdb36;
}
</style>
<table class="table table-stripedd table-bordered">
	<tr><th colspan="2" style="border-bottom: solid 2px;">{{$compte->libelle}} / <b>{{$secteur->nom}}</b><span class="fa fa-close remove-detail text-red" ></span>  </th></tr>
	<tr><th style="border-right: solid 2px;width:50%">ENTREES</th><th >SORTIES</th></tr>
	
	<tr>
		<td style="border-right: solid 2px;">
			<table class="table table-bordered">
				<tr class="bg-aqua" ><th style="text-align:left">COMPTES</th><th class="devise">USD</th><th class="devise">CDF</th></tr>
				@if($mouvements_entrees)
				<tr>
					<!-- AFFICHAGE -->
					<td>TOTAL</td>
					<td class="montant">{{ chiffre($mnt_tot_en_usd) }}</td>
					<td class="montant">{{ chiffre($mnt_tot_en_cdf) }}</td>									
				</tr>				
				@include('mes_vues.Cash._tr_detail_grand_livre',['typeCompte'=>'compteFinal','mouvements'=>$mouvements_entrees,'periode_mois'=>$periode_mois,'personnaliser_mois'=>$personnaliser_mois])
				@endif
			</table>
		</td>	
		<td>
			<table class="table table-bordered">
				<tr class="bg-red" ><th style="text-align:left">COMPTES</th><th class="devise">USD</th><th class="devise">CDF</th></tr>
				@if($mouvements_sorties)
				<tr>
					<!-- AFFICHAGE -->
					<td>TOTAL</td>
					<td class="montant">{{ chiffre($mnt_tot_so_usd) }}</td>
					<td class="montant">{{ chiffre($mnt_tot_so_cdf) }}</td>									
				</tr>
				@include('mes_vues.Cash._tr_detail_grand_livre',['typeCompte'=>'compteInitial','mouvements'=>$mouvements_sorties,'periode_mois'=>$periode_mois,'personnaliser_mois'=>$personnaliser_mois])
				@endif
			</table>
		</td>
	</tr>



	<tr>
		@if($solde_positif)
			<td>
				<table class="table bg-red "><tr>
					<td>Solde</td>
					<td class="montant" >{{ chiffre($solde_usd) }}</td>
					<td class="montant" >{{ chiffre($solde_cdf) }}</td>
				</tr></table>
			</td>
			<td></td>
		@else
			<td></td>
			<td>
				<table class="table bg-green "><tr>
					<td>Solde</td>
					<td class="montant" >{{ chiffre($solde_usd) }}</td>
					<td class="montant" >{{ chiffre($solde_cdf) }}</td>
				</tr></table>
			</td>
		@endif
	</tr>
</table>
