@extends("template")

@section('autre-menu-list')
	@include('mes_vues.Scholar._autre_menu')
@endsection

@section('style')
	<link href="{{asset('css/select2.min.css')}}" rel="stylesheet">
	<style>
	.select2-container--default .select2-selection--single {
		min-height: 34px;
	}
	.content, #content-list {
		padding: 0;
	}
	@media print{
	    #content-list.col-md-10 {
          width: 100% !important;
        }
        .table-bordered > thead > tr > td, .table-bordered > tbody > tr > td, .table-bordered > tfoot > tr > td {
            border: 1px solid #000;
            border-bottom-width: 1px;
        }
	}
	
@media print {
  .table-bordered thead tr th {
  border: solid 2px black !important;;
  }
  .table-bordered  tr td {
  border: solid 1px black !important;;
  }
}
	</style>
@endsection
@section('content')
@php
    $types_listes = ["elec"=>"FICHE D'IDENTIFICATION ELECTRONIQUE","pres"=>"GRILLE DE POINTAGE","cotation"=>"FICHE DE COTATION"
    ,"synthetique"=>"FICHE SYNTHETIQUE","code_secret"=>"CODE SECRET DES ELEVE","eleve"=>"LISTE DES ELEVES","deliberation"=>"FICHE DE DELIBERATION","palma"=>"PAMARES 75%"];
@endphp
<div class="col-md-12 col-md-offset-0 no-padding">

		<form enctype="multipart/form-data"  class="form-horizontal no-print"  id="form-paiement-frais" method="GET" action="{{route('scholar.fiche.electronique')}}" >
	<div class=" col-sm-12" style="margin-bottom: 20px;">
			<div class="col-sm-7" style="padding-left: 0px;">
				<select name="ms_classe_id[]" id="input-ms_classe_id-id" multiple class="form-control select2" style="width: 100%">
					@foreach($msClasses as $e)
						<option {{in_array($e->id,$id_classe)?"selected":""}} value="{{$e->id}}">{{$e->classe.' '.$e->msPromotion->promotion.' '.$e->msPromotion->section->nom_sec}}</option>
					@endforeach
				</select>
				
			</div>
		    <div class="col-sm-1" style="padding-left: 0px;">
				
						<input  class="btn btn-info no-print" type='button' id='all_visible_CLASSE' value='SELECT' />
				
			</div>
			<div class="col-sm-2" style="">
			    <select name="type_liste" id="input-type_liste-id" class="form-control select2" style="width: 100%">
			        @foreach($types_listes as $e=>$lbl)
						<option {{ ($type_liste==$e)?"selected":""}} value="{{$e}}">{{$lbl}}</option>
					@endforeach
				</select>
			</div>
			<div class="col-sm-1" style="">
				<button type="submit" class="btn btn-info ">CHARGER</button>
			</div>
			<div class="col-sm-1" style="">
			    		<label class="btn btn-danger no-print" onclick="window.print()"> <i class="fa fa-print"></i> IMPRIMER</label>
			</div>
			<!--div class="col-sm-4" style="">
				<input  name="select_file[]" class="form-control" multiple id="input-mois-id" type="file" style="padding: 0px;" />
			</div>
			<div class="col-sm-2" style="padding-right: 0px;">
				<button type="reset" class="btn btn-danger pull-right">Annuler</button>
				<button type="submit" class="btn btn-info pull-right " title='Importer les eleves dans la classe' >Importer</button>
			</div-->
	</div>
		</form>
	
	<div class="col-sm-12 no-padding" >
	    @if( $type_liste=="pres" )
	        @include('mes_vues.Scholar.listing._presence') 
	    @elseif( $type_liste=="cotation" )
	        @include('mes_vues.Scholar.listing._cotation')
	    @elseif( $type_liste=="synthetique" )
	        @include('mes_vues.Scholar.listing._cotation')
	    @elseif( $type_liste=="code_secret" )
	        @include('mes_vues.Scholar.listing._code_secret')
	    @elseif( $type_liste=="eleve" )
	        @include('mes_vues.Scholar.listing._liste_eleves')
	    @elseif( $type_liste=="deliberation" )
	        @include('mes_vues.Scholar.listing._liste_deliberation')
	    @elseif( $type_liste=="palma" )
	        @include('mes_vues.Scholar.listing._palmares')
	    @else
	    
	        @include('mes_vues.Scholar.listing._fiche_electronique')
	    @endif
	</div>
	

	</div>
@endsection
		
@section('script')
	@include("partials.export_js_files")
	<script src="{{asset('js/select2.full.min.js')}}"></script>
	
	<script>
	$(function () {
    //Initialize Select2 Elements
    $('.select2').select2({'placeholder':'choisir une ou plusieurs classes'})
    
    
		
		function select_all_visible(select2Holder){
					var visible = null; // TODO: how do we grab the filtered list?
             //   $('#state').val(visible).trigger('change');
 
				// Get the data object of state dropdown
                var filteredValues = [];
                
                if (select2Holder && select2Holder.select2) {
                    // Find the $results object
                    var results = select2Holder.select2.$results;
                    if (results) {
                      //  var resultNode$ = $(results[0]);
                      //  console.log(resultNode$);
                        
                        if ($(results[0]) && $(results[0]).children().length > 0) {
                            $(results[0]).children().each(function(index, node) {
                               
                                var selectedValue;
                                // Get the option value from attribute
                                var id = $(node).attr('id');
                                // id attribute will be like this 'select2-state-result-x3b0-NH'
                                // split the id attribute using "-" and get last value
                                var arr  = id.split('-');
                                if (arr && arr.length > 0) {
                                  selectedValue = arr[arr.length -1 ];
                                  filteredValues.push(selectedValue);
                                }

                                $(node).trigger('mouseup');
                              
                            })
                          
                        }
                        
                    }

                }
            
			}
			
			$('#all_visible_CLASSE').click(function(event) {
				event.preventDefault();
                var select2Holder = $('#input-ms_classe_id-id').data();
				select_all_visible(select2Holder)
			});
			@php
    	    if(isset($_GET['ms_classe_id'])){
    	        echo "$('#input-ms_classe_id-id').val(['".implode($_GET['ms_classe_id'],',')."']).change();";
    	        echo "$('#input-type_liste-id').val('".$_GET['type_liste']."').change();"; 
    	    }
	        @endphp
	})
	</script>
@endsection



