@extends("template")

@section('autre-menu-list')
	@include('mes_vues.Scholar._autre_menu')
@endsection

@section('content')
@php 
	// $effectif_ecole = $effectif_ecole->first() ;
	// dd($effectif_ecole);
	$total_effect = $total_effect_f = $total_effect_g = 0;
	if(isset($effectif_ecole['M']))
		$total_effect_g = $effectif_ecole['M']->count();
	if(isset($effectif_ecole['F']))
		$total_effect_f = $effectif_ecole['F']->count();

	$total_effect = $total_effect_f + $total_effect_g;
	$pour_f = round(divise(100*$total_effect_f,$total_effect),1);
	$pour_g = round(divise(100*$total_effect_g,$total_effect),1);
	
@endphp
<style>
	.table-bordered > thead > tr > th, .table-bordered > tbody > tr > th, .table-bordered > tfoot > tr > th, .table-bordered > thead > tr > td, .table-bordered > tbody > tr > td, .table-bordered > tfoot > tr > td {
  border: 1px solid #000;
}
</style>

<div class="col-md-12 col-md-offset-0">
	{{--	
	<div class="row">
		<div class="col-md-8 col-md-offset-2">
			<div class="box collapsed-box">
				<div class="box-header">
				<h3 class="box-title">Effectif général en <b>{{\App\Config::getAnnee()}}</b></h3>
				
				<div class="box-tools pull-right">
					<button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-plus"></i></button>
				</div>
				</div>
				<!-- /.box-header -->
				<div class="box-body no-padding" style="display: none;">
					<table class="table table-condensed">
						<tbody>
							<tr>
								<th>Libelles</th>
								<th>Effectifs</th>
								<th>Progressions</th><th style="width: 40px">(%)</th>
							</tr>
							<tr>
								<td>Nombre des Filles</td>
								<td> {{$total_effect_f}} élèves</td><td>
									<div class="progress progress-xs progress-striped active">
										<div class="progress-bar progress-bar-primary" style="width: {{$pour_f}}%"></div>
									</div>
								</td>
								<td><span class="badge bg-light-blue">{{$pour_f}}%</span></td>
							</tr>
							<tr>
								<td>Nombre des Garçons</td>
								<td> {{$total_effect_g}}  élèves</td><td>
									<div class="progress progress-xs progress-striped active">
										<div class="progress-bar progress-bar-success" style="width: {{$pour_g}}%"></div>
									</div>
								</td>
								<td><span class="badge bg-green">{{$pour_g}}%</span></td>
							</tr>
							<tr style="background: #4effff;">
								<td>Nombre total</td>
								<td>{{$total_effect}} élèves</td><td>
									<div class="progress progress-xs">
										<div class="progress-bar progress-bar-danger" style="width: 100%"></div>
									</div>
								</td>
								<td><span class="badge bg-red">100%</span></td>
							</tr>
							
						</tbody>
					</table>
				</div>
				<!-- /.box-body -->
			</div>
		</div>
	</div>
	--}}
		{{--<div class="row">
		  <div class="box collapsed-box">
            <div class="box-header" style="background: antiquewhite;">
              <h3 class="box-title" style="text-align:center;width:100%">EFFECTIF PAR SECTION</h3>
			  <div class="box-tools pull-right">
				<button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-plus"></i></button>
			  </div>
            </div>
            <!-- /.box-header -->
            <div class="box-body no-padding" style="display: none;">
						@foreach($effectif_section as $section=>$effectif)
              @php
								$total_effect = $total_effect_f = $total_effect_g = 0;
								if(isset($effectif['M']))
									$total_effect_g = $effectif['M']->count();
								if(isset($effectif['F']))
									$total_effect_f = $effectif['F']->count();

								$total_effect = $total_effect_f + $total_effect_g;
								$pour_f = round(100*$total_effect_f/$total_effect,1);
								$pour_g = round(100*$total_effect_g/$total_effect,1);
								
							@endphp
							<div class="col-md-4 text-center">
								
								<table class="table table-bordered table-hover text-center">
									<caption>
										<label class="box-title">Section {{$section}}</label>
									</caption>
									<tbody>
									<tr>
										<th>Filles</th>
										<th>Garçons</th>
										<th>Tous</th>
									</tr>
									<tr>
										<td>
											<div class="progress vertical progress-xs active">
												<div class="progress-bar progress-bar-info progress-bar-striped"
													role="progressbar" aria-valuenow="{{$pour_f}}" aria-valuemin="0"
													aria-valuemax="100" style="height: {{$pour_f}}%">
													<span class="sr-only">{{$pour_f}}%</span>
												</div>
											</div>
										</td>
										<td>
											<div class="progress vertical progress-xs active">
												<div class="progress-bar progress-bar-warning progress-bar-striped"
												role="progressbar" aria-valuenow="{{$pour_g}}" aria-valuemin="0"
												aria-valuemax="100" style="height: {{$pour_g}}%">
													<span class="sr-only">{{$pour_g}}%</span>
												</div>
											</div>
											
										</td>
										<td>
											<div class="progress vertical active progress-sm">
												<div class="progress-bar progress-bar-primary progress-bar-striped"
												role="progressbar" aria-valuenow="20" aria-valuemin="0" 
												aria-valuemax="100" style="height: 100%">
													<span class="sr-only">100%</span>
												</div>
											</div>
										</td>
									</tr>
									<tr>
										<th>{{$total_effect_f}} ({{$pour_f}}%)</th>
										<th>{{$total_effect_g}} ({{$pour_g}}%)</th>
										<th>{{$total_effect}} (100%)</th>
									</tr>
								</tbody>
								</table>
								
								
							</div>
						@endforeach
            </div>
            <!-- /.box-body -->
          </div>
		</div> --}}
		
		@php $effectif_classe = $effectif_classe->sortKeys(); @endphp
		@foreach($effectif_classe as $section=>$effectif_class)
		<div class=" col-md-6">
			<div class="box">
            <div class="box-header bg-aqua">
              <h3 class="box-title">Effectif par classe Section {{$section}}</h3>
			  
			  <div class="box-tools pull-right">
				<button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
			  </div>
            </div>
            <!-- /.box-header -->
			<style>.sep{border-right: solid 2px !important;}</style>
            <div class="box-body no-padding">
              <table class="table table-condensed table-hover table-striped table-bordered">
                <tbody><tr>
                  <th >#</th>
                  <th style="width: 250px">Classes</th>
                  <th style="text-align: center" colspan=3>ACTIFS</th>
                  <th style="text-align: center" colspan=3>ABANDONS</th>
                  <th>Elèves</th>
                </tr><tr>
                  <th ></th>
                  <th style="width: 250px"></th>
                  <th style="text-align: center">F</th>
                  <th style="text-align: center">G</th>
                  <th style="text-align: center" class="sep">TG</th>
                  <th style="text-align: center">F</th>
                  <th style="text-align: center">G</th>
                  <th style="text-align: center">TG</th>
                  <th></th>
                </tr>
				@php $effectif_class = $effectif_class->sortKeys(); 
				$sec_total_effect = $sec_total_effect_a = $sec_total_effect_f = $sec_total_effect_g =  $sec_total_effect_f_a = $sec_total_effect_g_a = 0;
						
				@endphp
				@foreach($effectif_class as $classe=>$effectif)
					@php 
					//dd($effectif['M']->get("Actif"));
						$total_effect = $total_effect_a = $total_effect_f = $total_effect_g =  $total_effect_f_a = $total_effect_g_a = 0;
						if(isset($effectif['M'])){
							$g = 'M';
							if($effectif[$g]->get("Actif")){								
								$id_classe = $effectif[$g]->get("Actif")->first()->ms_classe_id;
								$total_effect_g = $effectif[$g]->get("Actif")->count();
							}
							if($effectif[$g]->get("Abandon")){
								$id_classe = $effectif[$g]->get("Abandon")->first()->ms_classe_id;
								$total_effect_g_a = $effectif[$g]->get("Abandon")->count();
							}
						}
						if(isset($effectif['F'])){
							$g = 'F';
							if($effectif[$g]->get("Actif")){
								$id_classe = $effectif[$g]->get("Actif")->first()->ms_classe_id;								
								$total_effect_f = $effectif[$g]->get("Actif")->count();
							}
							if($effectif[$g]->get("Abandon")){
								$id_classe = $effectif[$g]->get("Abandon")->first()->ms_classe_id;
								$total_effect_f_a = $effectif[$g]->get("Abandon")->count();
							}
						}
						$total_effect = $total_effect_f + $total_effect_g;
						$total_effect_a = $total_effect_f_a + $total_effect_g_a;
						
						/*
						if(isset($effectif['F']) and count($effectif['F']))
							$id_classe = $effectif['F']->first()->ms_classe_id;
						else if(isset($effectif['M']) AND count($effectif['M']))
							$id_classe = $effectif['M']->first()->ms_classe_id;
						 */
						$sec_total_effect += $total_effect;
						$sec_total_effect_a += $total_effect_a;
						$sec_total_effect_f += $total_effect_f;
						$sec_total_effect_g +=  $total_effect_g;
						$sec_total_effect_f_a += $total_effect_a;
						$sec_total_effect_g_a += $total_effect_a;
				
					@endphp
					<tr>
						<td>{{$loop->index+1}}.</td>
						<td>
						<a target='_' href="{{ route('scholar.eleves',['ms_classe_id'=>$id_classe]) }}">{{$classe}}</a></td>
						<th style="text-align: center"><span classs="badge bg-yellow">{{$total_effect_f}}</span></th>
						<th style="text-align: center"><span classs="badge bg-green">{{$total_effect_g}}</span></th>
						<th style="color: #00c0ef;text-align: center"  class="sep"><span classs="badge bg-aqua">{{$total_effect}}</span></th>
						<th style="text-align: center"><span classs="badge bg-yellow">{{$total_effect_f_a}}</span></th>
						<th style="text-align: center"><span classs="badge bg-green">{{$total_effect_g_a}}</span></th>
						<th style="color: #00c0ef;text-align: center"><span classs="badge bg-aqua">{{$total_effect_a}}</span></th>
						<td>
							<a target='_' class="btn btn-small btn-info btn-xs" href="{{ route('scholar.eleves',['ms_classe_id'=>$id_classe]) }}">voir élèves</a>
						</td>
					</tr>
                @endforeach
					<tr>
						<td>{{$loop->index+1}}.</td>
						<td>
						<a  href="#">TOTAL</a></td>
						<th style="text-align: center"><span classs="badge bg-yellow">{{$sec_total_effect_f}}</span></th>
						<th style="text-align: center"><span classs="badge bg-green">{{$sec_total_effect_g}}</span></th>
						<th style="color: #00c0ef;text-align: center"  class="sep"><span classs="badge bg-aqua">{{$sec_total_effect}}</span></th>
						<th style="text-align: center"><span classs="badge bg-yellow">{{$sec_total_effect_f_a}}</span></th>
						<th style="text-align: center"><span classs="badge bg-green">{{$sec_total_effect_g_a}}</span></th>
						<th style="color: #00c0ef;text-align: center"><span classs="badge bg-aqua">{{$sec_total_effect_a}}</span></th>
						<td>
						</td>
					</tr>
					</tbody>
				</table>
            </div>
            <!-- /.box-body -->
          </div>
		</div>
		@endforeach
		
		<div class=" col-md-6">
		  <div class="box">
            <div class="box-header bg-aqua">
              <h3 class="box-title">Effectif par status</h3>
			  
			  <div class="box-tools pull-right">
				<button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
			  </div>
            </div>
            <!-- /.box-header -->
			<style>.sep{border-right: solid 2px !important;}</style>
            <div class="box-body no-padding">
				<table class="table table-condensed table-hover table-striped table-bordered">
					<thead>
						<tr>
							<th >#</th>
							<th style="width: 250px">STATUS</th>
							<th style="text-align: center" >ACTIFS</th>
							<th style="text-align: center" >ABANDONS</th>
							<th style="text-align: center" >TOTAL</th>
							<th>Elèves</th>
						</tr>
					</thead>
					<tbody>
						@foreach($effectif_par_status as $status=>$liste)
						@php 
						$tot = $liste->count();
						$status_id = $liste->first()->status_enfant_id;
						$n_actif = $liste->filter(function ($value, $key) {
												return $value->etat == "Actif";
											})->count();
						$n_abdon = $tot - $n_actif;
						@endphp
						<tr>
							<td>{{$loop->index+1}}</td>
							<td>{{$status}}</td>
							<td style="text-align: center">{{$n_actif}}</td>
							<td style="text-align: center">{{$n_abdon}}</td>
							<td style="text-align: center">{{$tot}}</td>
							<td>
								<a target='_' class="btn btn-small btn-info btn-xs" href="{{ route('scholar.eleves.status',['status'=>$status_id]) }}">voir élèves</a>
							</td>
						</tr>
						@endforeach
					</tbody>
				</table>
				
			</div>
            <!-- /.box-body -->
          </div>
		</div>
	</div>
					
@endsection
					