@extends("template")

@section('autre-menu-list')
	@include('mes_vues.Scholar._autre_menu')
@endsection

@section('content')
<div class="col-md-12 col-md-offset-0">

	

	<!-- if there are creation errors, they will show here -->
	<ul>
	@foreach($errors->all() as $e)
		<li>{{ $e }}</li>
	@endforeach
	</ul>
	<div class="col-sm-offset-3 col-sm-6" >
		<div class="box box-info collapsed-box">
			<div class="box-header with-border">
				<h3 class="box-title">Ajouter une nouvelle classe</h3>
				
				<div class="box-tools pull-right">
					<button type="button" class="btn btn-box-tool" data-widget="collapse">
					<i class="fa fa-plus"></i></button>
				</div>
			</div>
			<!-- /.box-header -->
			<!-- form start -->
					{{csrf_field()}}
			<div class="box-body" style="display:none">
				<form enctype="multipart/form-data" class="form-horizontal" action="{{route('msclasses.store')}}" method="POST">
					{{csrf_field()}}
					<div class="col-sm-offset-3 col-sm-9" style='display:none'>
						<div class="checkbox">
							<label style="color: #7d4982;font-weight: bold;font-style: italic;">
								<input type="checkbox" checked name="keep_the_form">Rester sur le formulaire.
							</label>
						</div>
					</div>
					@include('Masomwetu.Scholar.msclasses._form',['submitButtonText'=>'Enregistrer'])
				<a href='#x' class="btn btn-info" onclick="show_form('ajouter-promotion')">Ajouter nouvelle promotion</a>
				</form>
				<br/>
				
				<div class="box box-success collapsed-box" id='ajouter-promotion' style='display:none;'>
					<div class="box-header with-border">
						<h3 class="box-title">Ajouter une nouvelle promotion</h3>						
						<div class="box-tools pull-right">
							<button type="button" class="btn btn-box-tool" data-widget="collapse">
							<i class="fa fa-plus"></i></button>
						</div>
					</div>
					<!-- /.box-header -->
					<!-- form start -->
							{{csrf_field()}}
					<div class="box-body" style="display:none">
						<form enctype="multipart/form-data" class="form-horizontal" action="{{route('mspromotions.store')}}" method="POST">
							{{csrf_field()}}
							<div class="col-sm-offset-3 col-sm-9" style='display:none'>
								<div class="checkbox">
									<label style="color: #7d4982;font-weight: bold;font-style: italic;">
										<input type="checkbox" checked name="keep_the_form">Rester sur le formulaire.
									</label>
								</div>
							</div>
							@include('Masomwetu.Scholar.mspromotions._form',['submitButtonText'=>'Enregistrer'])
							<a href='#x' class="btn btn-info" onclick="show_form('ajouter-section')">Ajouter nouvelle section</a>
						</form>
						<br/>
						
						<div class="box box-success collapsed-box" id='ajouter-section' style='display:none;'>
							<div class="box-header with-border">
								<h3 class="box-title">Ajouter une nouvelle Section</h3>						
								<div class="box-tools pull-right">
									<button type="button" class="btn btn-box-tool" data-widget="collapse">
									<i class="fa fa-plus"></i></button>
								</div>
							</div>
							<!-- /.box-header -->
							<!-- form start -->
									{{csrf_field()}}
							<div class="box-body" style="display:none">
								<form enctype="multipart/form-data" class="form-horizontal" action="{{route('sections.store')}}" method="POST">
									{{csrf_field()}}
									<div class="col-sm-offset-3 col-sm-9" style='display:none'>
										<div class="checkbox">
											<label style="color: #7d4982;font-weight: bold;font-style: italic;">
												<input type="checkbox" checked name="keep_the_form">Rester sur le formulaire.
											</label>
										</div>
									</div>
									@include('Masomwetu.School.sections._form',['submitButtonText'=>'Enregistrer'])
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
			@php display_flash(); @endphp
	</div>
	<div class="col-sm-12" >
	<div class="box" style="padding: 0 10px;">
		<div class="box-header">
			<h3 class="box-title">Classes de: <b>{{ \App\Config::getEcole() }}</b> Année Scolaire <b>{{ \App\Config::getAnnee()}}</b>
			</h3>
		</div>
		<!-- /.box-header -->
		<div class="box-body no-padding" >
						
						
			<table id="datatable-msclasses" class="table table-striped table-bordered table-condensed table-hover">
				<thead>
						<tr>
							
							<th></th>
							<th>Classe</th>
							<th>Promotion</th>
							<th>Section</th>
							<th><a title="Telecharger la grille des tous les eleves" class="btn btn-small btn-info btn-xs" target='_blank' 
							href="{{ route('export.tous.les.eleves') }}"> <i class="fa fa-download"></i> 
							<i class="fa fa-file-excel-o"></i> ELEVES</a></th>
							<th>CARTES</th>
							<th>Grille</th>
							<th><a class="btn btn-small btn-success btn-xs" target='_blank' 
							href="{{ route('scholar.export.eleve',['id'=>0]) }}"> <i class="fa fa-download"></i> 
							<i class="fa fa-file-excel-o"></i> Toutes les classes</a>
				</th>
						</tr>
				</thead>
				<tbody>
				@foreach($msClasses as $key => $msclasse)
					<tr>
						<td>{{$loop->index+1}}</td>		
						<td>{{ $msclasse->classe }}</td>
						<td>{{ $msclasse->msPromotion->promotion??'NO-PROMOTION' }} {{$msclasse->msPromotion->msAnneeScolaire->annee??''}}</td>
						<td>{{ $msclasse->msPromotion->section->nom_sec??'NO-SECTION' }}</td>
							
						<td>
							<a class="btn btn-small btn-info btn-xs" href="{{ route('scholar.eleves',['ms_classe_id'=>$msclasse->id]) }}">ELEVES.</a>
						</td>
						<td>
							<a class="btn btn-small btn-warning btn-xs" target='_blank' href="{{ route('scholar.eleves.cartes',['id_classe'=>$msclasse->id]) }}">CARTES.</a>
						</td>
						<td>
							<a class="btn btn-small btn-info btn-xs" target='_blank' href="{{ route('export.grille.vide.eleves',['id_classe'=>$msclasse->id]) }}"> <i class="fa fa-download"></i> <i class="fa fa-file-excel-o"></i> Grille INSC</a>
						</td>
						<td>
							<a class="btn btn-small btn-success btn-xs" target='_blank' href="{{ route('scholar.export.eleve',['id'=>$msclasse->id]) }}"> <i class="fa fa-download"></i> <i class="fa fa-file-excel-o"></i> Grille FRAIS</a>
						</td>
					</tr>
				@endforeach
				</tbody>
			</table>
		</div>
		<div class="box-header">
			<p><b>{{ count($msClasses) }}</b> Classes	</p>
		</div>
	</div>
	</div>
	</div>
@endsection
@section('script')
	<script>
	function show_form(id){
		document.getElementById(id).style.display='block';
	}
	</script>
@endsection